<?php
// $Id: banner_image.inc.php 5 2008-12-12 05:55:19Z adgar $

require_once('fileuploader.inc.php');

function addImageBanner($groupid, $descr, $location, &$uploadfile) { 
    global $db, $param;
    $insert = array('group_id' => $groupid, 'type' => '', 'location' => $location, 'width'  => '', 'height' => '', 'descr' => $descr);
    //update image file
    if (!($uploadfile['error'] == 4 && $uploadfile['size'] == 0)) {
        $foo = (int) $db->getOne("SELECT max(banner_id) FROM $param[dbprefix]banners");
        $file = 'image' . ($foo+1) . strrchr($uploadfile['name'], '.');
        $savefilename = SCRIPT_REALPATH . DIRECTORY_SEPARATOR . BANNER_FOLDER . DIRECTORY_SEPARATOR . 'img'. DIRECTORY_SEPARATOR . $file;
        $fu =& new FileUploader($uploadfile, $savefilename, AFFPRO_UPLOAD_IMAGES);
        $foo = $fu->upload(0777);
        if (!AFFPRO::isError($foo)) {
            $foo = @getimagesize($savefilename);
            $insert['width'] = $foo[0];  
            $insert['height']= $foo[1];  
            $insert['type'] = 'img';
            $insert['location'] = $file; 
        } else {
            return $foo;
        }
    }
    //update banner url
    else if (!empty($location)) {
        $foo = @getimagesize($location);
        if (!$foo) {
            return  AFFPRO::raiseError('ERROR_INCORRECT_GRAPHFILE');
        } else {
            $insert['width'] = $foo[0];  
            $insert['height']= $foo[1];  
            $insert['type'] = 'imgurl'; 
            $insert['location'] = $location;
        }
    } 
    else {
        return  AFFPRO::raiseError('TT_INCORRECT_FILE_TYPE');        
    }
    $sql = sql_placeholder("INSERT INTO $param[dbprefix]banners (group_id, type, location, width, height, descr) VALUES (?@)", $insert);
    $db->query($sql);
    return true;   
}

function deleteImageBanner($banner_id) {   
    global $db, $param; 
    $rs = $db->query("SELECT * FROM $param[dbprefix]banners WHERE banner_id=?", array($banner_id));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {         
        if ('img' == $row['type']) {
           $path_to_banner = SCRIPT_REALPATH . DIRECTORY_SEPARATOR . BANNER_FOLDER . DIRECTORY_SEPARATOR . 'img'. DIRECTORY_SEPARATOR . $row['location'];   
           @unlink($path_to_banner);        
        }
        $db->query("DELETE FROM $param[dbprefix]banners WHERE banner_id=?", array($banner_id));
    }
    return;
}

function createImageBannerHtmlCode($bannerid, $affid, $testmode=false) {
    global $db, $param;
    $rs = $db->query("SELECT * FROM $param[dbprefix]banners WHERE banner_id =?", array($bannerid));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $bannerHtmlCode = createImageBannerHtmlCode2($row, $affid, $testmode);
        return $bannerHtmlCode;     
    } else {        
        return;        
    }
}  

function createImageBannerHtmlCode2($bandata, $affid,  $testmode=false) {
    $http_base_url = rtrim(HTTP_ADDR, '/');
    $bannerUrl = "$http_base_url/affiliate/affiliate.php?id=$affid&group=$bandata[group_id]";   
    $bannerSrc = $http_base_url . '/' . BANNER_FOLDER . '/imgcontainer.php';
    $bannerSrc .= "?group_id=$bandata[group_id]&banner_id=$bandata[banner_id]&aff_id=$affid";
    if ($testmode) {
        $bannerUrl .= '&testmode=1';
        $bannerSrc .= '&testmode=1';
    }       
    $bannerHtmlCode = "<a href=\"$bannerUrl\" title=\"" . htmlspecialchars($bandata['descr'], ENT_QUOTES, 'UTF-8') . "\" target=\"_blank\"";
    $bannerHtmlCode .= "><img src=\"$bannerSrc\"";
    $bannerHtmlCode .= (!empty($bandata['width'])) ? " width=\"$bandata[width]\"" : "";
    $bannerHtmlCode .= (!empty($bandata['height'])) ? " height=\"$bandata[height]\"" : "";      
    $bannerHtmlCode .= " border=\"0\" alt=\"\" /></a>";
    return $bannerHtmlCode;
}

function updateImageBanner($banner_id, $width, $height, $group_id, $description, $location, &$uploadfile) {
    global $db, $param;
    $update = array('group_id'=> $group_id, 'descr' => $description); 
    if ($width > 0)  $update['width'] = $width;
    if ($height > 0) $update['height'] = $height;
    $return = true;
    //update image file
    if (!($uploadfile['error'] == 4 && $uploadfile['size'] == 0)) {
        $file = 'image' . $banner_id . strrchr($uploadfile['name'], '.');
        $savefilename = SCRIPT_REALPATH . DIRECTORY_SEPARATOR . BANNER_FOLDER . DIRECTORY_SEPARATOR . 'img'. DIRECTORY_SEPARATOR . $file;
        $fu =& new FileUploader($uploadfile, $savefilename, AFFPRO_UPLOAD_IMAGES);
        $return = $fu->upload(0777);
        if (!AFFPRO::isError($return)) {
            $foo = @getimagesize($savefilename);
            $update['width'] = $foo[0];  
            $update['height']= $foo[1];  
            $update['type'] = 'img';
            $update['location'] = $file; 
        }
    }
    //update banner url
    else if (!empty($location)) {        
        $foo = @getimagesize($location);        
        if (!$foo) {
            $return = AFFPRO::raiseError('ERROR_INCORRECT_GRAPHFILE');
        } else {
            $update['width'] = $foo[0];  
            $update['height']= $foo[1];  
            $update['type'] = 'imgurl'; 
            $update['location'] = $location;
            $return = true;
        }
    }
    $sql = sql_placeholder("UPDATE $param[dbprefix]banners SET ?% WHERE banner_id=?", $update, $banner_id); 
    $db->query($sql);
    return $return; 
}

?>