<?php
// $Id: banner_counter.inc.php 5 2008-12-12 05:55:19Z adgar $

require_once('realip.lib.php'); 

function count_img_swf_impression($user_id, $banner_id) {
    if (0 == $user_id || 0 == $banner_id) return;       
    global $db, $param, $block_types;    
    $from_ip = get_real_IP();    
    $date = array(
    'now' => date('Y-m-d H:i:s'),
    'date_from' => date('Y-m-d 00:00:00'),
    'date_to' => date('Y-m-d 23:59:59'),
    'blockdate' => strftime('%Y-%m-%d %H:%M:%S', time()+86400)  //time() + 1 day
    );    
    //add info into block_ip table
    $block_ip_rs = $db->query("SELECT * FROM $param[dbprefix]blocked_ip WHERE block_type=? AND ip=? AND primary_key=? AND secondary_key=? ORDER BY time DESC LIMIT 0,1", array($block_types['img_impression_ip_block'], $from_ip, $user_id, $banner_id));
    if ($block_ip_row = $block_ip_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        if (time() < strtotime($block_ip_row['time'])) {
            return;
        } else {
            $db->query("UPDATE $param[dbprefix]blocked_ip SET time=? WHERE block_type=? AND ip=? AND primary_key=? AND secondary_key=?", array($date['blockdate'], $block_types['img_impression_ip_block'], $from_ip, $user_id, $banner_id));
        }
    } else {
        $sql = sql_placeholder("INSERT INTO $param[dbprefix]blocked_ip (ip, block_type, time, primary_key, secondary_key) VALUES(?@)", array(
        'ip' => $from_ip,
        'block_type' => $block_types['img_impression_ip_block'], 
        'time' => $date['blockdate'],
        'primary_key'=> $user_id,
        'secondary_key' => $banner_id
        )
        );
        $db->query($sql); 
    }
    //add info into impressions table
    $cnt = (int) $db->getOne("SELECT count(*) FROM $param[dbprefix]banners_impressions WHERE user_id=? AND banner_id=? AND date_from<=? AND date_to>=?", array($user_id, $banner_id, $date['now'], $date['now']));
    if (0 == $cnt) {
        $sql = sql_placeholder("INSERT INTO $param[dbprefix]banners_impressions (user_id, banner_id, date_from, date_to, total_cnt) VALUES (?@)", array(
        'user_id' => $user_id,
        'banner_id' => $banner_id,
        'date_from' => $date['date_from'],
        'date_to' => $date['date_to'],
        'total_cnt'=> 1
        )
        );
        $db->query($sql);
    } else {    
        $db->query("UPDATE $param[dbprefix]banners_impressions SET total_cnt=total_cnt+1 WHERE user_id=? AND banner_id=? AND date_from<=? AND date_to>=?", array($user_id, $banner_id, $date['now'], $date['now']));
    }    
    return;
}

function count_ads_impression($user_id, $ad_id) {
    if (0 == $user_id || 0 == $ad_id) return;       
    global $db, $param, $block_types;    
    $from_ip = get_real_IP();    
    $date = array(
    'now' => date('Y-m-d H:i:s'),
    'date_from' => date('Y-m-d 00:00:00'),
    'date_to' => date('Y-m-d 23:59:59'),
    'blockdate' => strftime('%Y-%m-%d %H:%M:%S', time()+86400)  //time() + 1 day
    );    
    //add info into block_ip table
    $block_ip_rs = $db->query("SELECT * FROM $param[dbprefix]blocked_ip WHERE block_type=? AND ip=? AND primary_key=? AND secondary_key=? ORDER BY time DESC LIMIT 0,1", array($block_types['ads_impression_ip_block'], $from_ip, $user_id, $ad_id));
    if ($block_ip_row = $block_ip_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        if (time() < strtotime($block_ip_row['time'])) {
            return;
        } else {
            $db->query("UPDATE $param[dbprefix]blocked_ip SET time=? WHERE block_type=? AND ip=? AND primary_key=? AND secondary_key=?", array($date['blockdate'], $block_types['ads_impression_ip_block'], $from_ip, $user_id, $ad_id));
        }
    } else {
        $sql = sql_placeholder("INSERT INTO $param[dbprefix]blocked_ip (ip, block_type, time, primary_key, secondary_key) VALUES(?@)", array(
        'ip' => $from_ip,
        'block_type' => $block_types['ads_impression_ip_block'], 
        'time' => $date['blockdate'],
        'primary_key'=> $user_id,
        'secondary_key' => $ad_id
        )
        );
        $db->query($sql); 
    }
    //add info into impressions table
    $cnt = (int) $db->getOne("SELECT count(*) FROM $param[dbprefix]textads_impressions WHERE user_id=? AND ad_id=? AND date_from<=? AND date_to>=?", array($user_id, $ad_id, $date['now'], $date['now']));
    if (0 == $cnt) {
        $sql = sql_placeholder("INSERT INTO $param[dbprefix]textads_impressions (user_id, ad_id, date_from, date_to, total_cnt) VALUES (?@)", array(
        'user_id' => $user_id,
        'ad_id' => $ad_id,
        'date_from' => $date['date_from'],
        'date_to' => $date['date_to'],
        'total_cnt'=> 1
        )
        );
        $db->query($sql);
    } else {    
        $db->query("UPDATE $param[dbprefix]textads_impressions SET total_cnt=total_cnt+1 WHERE user_id=? AND ad_id=? AND date_from<=? AND date_to>=?", array($user_id, $ad_id, $date['now'], $date['now']));
    }    
    return;
}

function count_click($userid, $product_id) {
	global $db, $param, $block_types; 
    $from_ip = get_real_IP();
	//create date array
	$clickdate = array(
	'date' => date('Y-m-d'),
	'blockdate' => strftime('%Y-%m-%d %H:%M:%S', time()+86400)  //time() + 1 day
	);
	//add info into block_ip table
    $block_ip_rs = $db->query("SELECT * FROM $param[dbprefix]blocked_ip WHERE block_type=? AND ip=? AND primary_key=? ORDER BY time DESC LIMIT 0,1", array($block_types['traffic_ip_block'], $from_ip, $product_id));       
    if ($block_ip_row = $block_ip_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        if (time() < strtotime($block_ip_row['time'])) {
            return;
        } else {
            $db->query("UPDATE $param[dbprefix]blocked_ip SET time=? WHERE block_type=? AND ip=? AND primary_key=?", array($clickdate['blockdate'], $block_types['traffic_ip_block'], $from_ip, $product_id));
        }
    } else {
        $sql = sql_placeholder("INSERT INTO $param[dbprefix]blocked_ip (ip, block_type, time, primary_key) VALUES(?@)", array(
        'ip' => $from_ip,
        'block_type' => $block_types['traffic_ip_block'], 
        'time' => $clickdate['blockdate'],
        'primary_key'=> $product_id
        )
        );
        $db->query($sql); 
    }
    //add info into traffic table
    $click_cnt = $db->getOne("SELECT count(*) FROM $param[dbprefix]traffic WHERE user_id=? AND create_date=? AND product_id=?", array($userid, $clickdate['date'], $product_id));        
    if (empty($_SERVER['HTTP_REFERER'])) {
        $from_log = $from_ip . "\n";
    } else {
        $from_log = $_SERVER['HTTP_REFERER'] . "\n";
    }
    if (0 == $click_cnt) {
        $sql = sql_placeholder("INSERT INTO $param[dbprefix]traffic(user_id, create_date, clickcount, product_id, from_log) VALUES (?@)", array(
        'user_id' => $userid,
        'create_date' => $clickdate['date'],
        'clickcount' => 1,
        'product_id' => $product_id,
        'from_log' => $from_log
        )
        );
        $db->query($sql);
    } else {
        $db->query("UPDATE $param[dbprefix]traffic SET clickcount=clickcount+1, from_log=CONCAT(from_log, ?) WHERE user_id=? AND create_date=? AND product_id=?", array($from_log, $userid, $clickdate['date'], $product_id));
    }
	return;
}

?>