<?php
// $Id: admin_traffic.php 13 2009-08-06 04:54:25Z adgar $

require_once('../jpgraph.php');
require_once('../jpgraph_bar.php');
require_once('../../admin/admincfg.php');
require_once('imgcfg.php');

//source data       
if (!empty($sql_q) && !empty($_GET['from'])) {
    require_once('filters.inc.php');
    $foo = strtotime(preg_replace($date_patterns, $date_replacements, $_GET['from']));
    $year=date('Y', $foo)+1;  
    $month=date('m', $foo);     
} else {
    $year=date('Y');      
    $month=date('m');
}
 
$i=12;
while ($i>=0) {  
    $startdate = strftime("%Y-%m-%d",mktime(0, 0, 0, $month-$i, 1, $year));
    $stopdate = strftime("%Y-%m-%d",mktime(23, 59, 59, $month-$i+1, 0, $year));        
    $rs = $db->query("SELECT sum(t1.clickcount) as clickscount FROM $param[dbprefix]traffic as t1 INNER JOIN $param[dbprefix]users as t2  ON (t1.user_id=t2.id) WHERE (t2.usertype not in (?, ?, ?)) AND (t1.create_date>=?) AND (t1.create_date<=?)", array($users_types['primary_admin'], $users_types['super_admin'], $users_types['admin'], $startdate, $stopdate));
    $row=$rs->fetchRow(DB_FETCHMODE_ASSOC);      
    $dataY1[]=$row['clickscount'];
    $dataY2[]=$db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE (approved=1) AND (txn_type=?) AND (create_date>=?) AND (create_date<=?)", array($transaction_types['credit_primary'], $startdate, $stopdate));
    $dataY3[]=$db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE (txn_type=?) AND (create_date>=?) AND (create_date<=?)", array($transaction_types['debit_chargeback'], $startdate, $stopdate));
    $dataX[]=strftime('%b %Y', mktime(0,0,0,$month-$i, 1, $year)); 
//        echo $starttime - $stoptime."<br />".$dataX[count($dataX)-1]."<br />";   
    $i--;        
}

// Create the graph. These two calls are always required
$graph = new Graph(600,220,'');
$graph->img->SetMargin(30,190,30,65);       

//color
$graph->SetColor(array(233,242,255));
$graph->SetMarginColor(array(233,242,255));
$graph->legend->Pos(0.01,0.2,"right","center");   

// Create the bar plots
$b1plot = new BarPlot($dataY1);
$b1plot->SetFillColor("orange");
$b1plot->SetLegend(getTranslateText('TRAFF_GR_UNICLICK'));  
$b2plot = new BarPlot($dataY2);
$b2plot->SetFillColor("blue");
$b2plot->SetLegend(getTranslateText('TRAFF_GR_APPROVESALES'));      
$b3plot = new BarPlot($dataY3);
$b3plot->SetFillColor("red");
$b3plot->SetLegend(getTranslateText('TRAFF_GR_CHARGEBACK')); 

$gbplot = new GroupBarPlot(array($b1plot, $b2plot, $b3plot));   
$graph->Add($gbplot);

$graph->SetScale("textlin");
//title
$graph->title->Set(getTranslateText(8));
SetFont($graph->title, FF_ARIALUNI, FS_NORMAL, 10);
SetFont($graph->legend, FF_ARIALUNI, FS_NORMAL, 8);

//x
$graph->xaxis->SetLabelAngle(90);    
$graph->xaxis->SetTickLabels($dataX);
SetFont($graph->xaxis, FF_ARIALUNI, FS_NORMAL, 8);

//y
SetFont($graph->yaxis->title, FF_CURRENCY, FS_NORMAL, 9);
SetFont($graph->yaxis, FF_ARIALUNI, FS_NORMAL, 8);

// Display the graph
$graph->Stroke();

?>