<?php
// $Id: admin_quick_stats.php 13 2009-08-06 04:54:25Z adgar $

require_once('../jpgraph.php');
require_once('../jpgraph_bar.php');
require_once('../../admin/admincfg.php');
require_once('imgcfg.php');
require_once('transactionbuilder.inc.php');

//source data

$rs = $db->query("SELECT t1.txn_type, abs(sum(t1.orig_amount)) as orig_amount, abs(sum(t1.amount)) as amount, t1.orig_cur_index, t1.daily_number, t1.weekly_number, t1.bi_weekly_number, t1.monthly_number, t1.half_monthly_number FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 $sql_q ORDER BY t1.create_date DESC", null, DB_FETCHMODE_ASSOC);

switch (intval($_REQUEST['filter_txn_period'])) {
    case $date_period_types['daily_number']: 
    $period_key = 0;
    $title = getTranslateText('TT_DAILY'); 
    $img_size = array(280, 120);
    break;        
    case $date_period_types['weekly_number']: 
    $period_key = 1;
    $title = getTranslateText('TT_WEEKLY');    
    $img_size = array(320, 160);    
    break;        
    case $date_period_types['bi_weekly_number']: 
    $period_key = 2;
    $title = getTranslateText('TT_BI_WEEKLY');    
    $img_size = array(320, 160);    
    break;        
    case $date_period_types['half_monthly_number']: 
    $period_key = 4;
    $title = getTranslateText('TT_HALF_MONTHLY');    
    $img_size = array(320, 160);    
    break;        
    default: 
    $period_key = 3;
    $title = getTranslateText('TT_MONTHLY');        
    $img_size = array(220, 65);    
    break;
}

if (0 == $rs->numRows()) {
    $dataX = array('');
    $dataY = array(
        '0' => array(0),
        '1' => array(0),
        '2' => array(0),
        '3' => array(0),
        '4' => array(0),
        '5' => array(0)
    );      
} else {    
    $dataX = array();
    $dataY = array(
        '0' => array(),
        '1' => array(),
        '2' => array(),
        '3' => array(),
        '4' => array(),
        '5' => array()
    ); 
        
    $report_data1 = array();
    
    $cell_name = array_search($period_key, $date_period_types);

    while($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $key_one = $row[$cell_name];
        $key_two = $row['txn_type']; 
        $report_data1[$key_one][$key_two] = moneyConvert($row['amount'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    }  
//    $report_data1
    $interval_keys = array_keys($report_data1);   
    $interval_str = getFormatStrInterval($period_key, $interval_keys);
    
//    print_r($report_data1); echo "<br />";
//    ksort($report_data1);
    //print data

//    print_r($report_data1); die();
    $i = 0;
    foreach ($report_data1 as $period_key => $data) { 
        $dataX[] = $interval_str[$period_key];
        $dataY[0][$i] = $dataY[1][$i] = $dataY[2][$i] = $dataY[3][$i] = $dataY[4][$i] = $dataY[5][$i] = 0; 
        $dataY[0][$i] += $data[0];
        $dataY[1][$i] += $data[1];
        $dataY[2][$i] += $data[2];
        $dataY[3][$i] += $data[5];
        $dataY[4][$i] += $data[7];
        $dataY[5][$i] += $data[9];
        $i++;
        if ($i>=9) break;
    }
}

//print_r($dataY); die();

$dataX = array_reverse($dataX);
$dataY[0] = array_reverse($dataY[0]);
$dataY[1] = array_reverse($dataY[1]); 
$dataY[2] = array_reverse($dataY[2]);
$dataY[3] = array_reverse($dataY[3]);
$dataY[4] = array_reverse($dataY[4]); 
$dataY[5] = array_reverse($dataY[5]);
        

// Create the graph. These two calls are always required
$graph = new Graph(600,$img_size[0],'');
$graph->img->SetMargin(60,180,30,$img_size[1]);       

//color
$graph->SetColor(array(233,242,255));
$graph->SetMarginColor(array(233,242,255));
$graph->legend->Pos(0.01,0.35,"right","center");   

// Create the bar plots
$b0plot = new BarPlot($dataY[0]);
$b0plot->SetFillColor("orange");
$b0plot->SetLegend(getTranslateText('TXNTYPE_SALESCOMISSION'));  

$b1plot = new BarPlot($dataY[1]);
$b1plot->SetFillColor("blue");
$b1plot->SetLegend(getTranslateText('TXNTYPE_TIERCOMISSION'));  

$b2plot = new BarPlot($dataY[2]);
$b2plot->SetFillColor("green");
$b2plot->SetLegend(getTranslateText('TXNTYPE_INITIALBONUS')); 

$b3plot = new BarPlot($dataY[3]);
$b3plot->SetFillColor("red");
$b3plot->SetLegend(getTranslateText('TXNTYPE_CHARGEBACK')); 

$b4plot = new BarPlot($dataY[4]);
$b4plot->SetFillColor("aqua");
$b4plot->SetLegend(getTranslateText('TXNTYPE_PAYOUT')); 

$b5plot = new BarPlot($dataY[5]);
$b5plot->SetFillColor("cornflowerblue");
$b5plot->SetLegend(getTranslateText('TXNTYPE_TRAFFIC')); 

$gbplot = new GroupBarPlot(array($b0plot, $b1plot, $b2plot, $b3plot, $b4plot, $b5plot));

$graph->Add($gbplot);
$graph->SetScale('textlin');

//title
$title = getTranslateText('TT_QUICK_STATS') . ' - ' . $title;
$graph->title->Set($title);
SetFont($graph->title, FF_ARIALUNI, FS_NORMAL, 10);
SetFont($graph->legend, FF_ARIALUNI, FS_NORMAL, 8);

//x
$graph->xaxis->SetLabelAngle(90);
$graph->xaxis->SetTickLabels($dataX);    
SetFont($graph->xaxis, FF_ARIALUNI, FS_NORMAL, 8);

//y
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? ($currency['cur_symbol'] . ' - ' . $currency['cur_alpha3']) : $currency['cur_alpha3'];
$graph->yaxis->title->Set($currency_text);
$graph->yaxis->title->SetMargin(20); 
SetFont($graph->yaxis->title, FF_CURRENCY, FS_NORMAL, 9);
SetFont($graph->yaxis, FF_ARIALUNI, FS_NORMAL, 8);

// Display the graph
$graph->Stroke();

?>