<?php
// $Id: admin_cursales.php 5 2008-12-12 05:55:19Z adgar $

require_once('../jpgraph.php');
require_once('../jpgraph_bar.php');
require_once('../../admin/admincfg.php');
require_once('imgcfg.php');

$rs_app = $db->query("SELECT sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 INNER JOIN $param[dbprefix]users as t2 ON (t1.user_id=t2.id) WHERE (t2.usertype=?) AND (t1.approved=1) AND (t2.approved=1) GROUP BY t1.user_id, t1.orig_cur_index", array($users_types['affiliater']));
$rs_noapp = $db->query("SELECT sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 INNER JOIN $param[dbprefix]users as t2 ON (t1.user_id=t2.id) WHERE (t2.usertype=?) AND (t1.approved=0) AND (t2.approved=1) GROUP BY t1.user_id, t1.orig_cur_index", array($users_types['affiliater']));
$total = array(
    'approved' =>  0,
    'nonapproved' =>  0
);

//$key_one = DEFAULT_JOIN_CURRENCY;
while ($row_app  = $rs_app->fetchRow(DB_FETCHMODE_ASSOC)) {
    $total['approved'] += moneyConvert($row_app['amount'], $row_app['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
}

while ($row_noapp  = $rs_noapp->fetchRow(DB_FETCHMODE_ASSOC)) {
    $total['nonapproved'] += moneyConvert($row_noapp['amount'], $row_noapp['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
}

$dataY1[0]= $total['approved'];
$dataY2[0]= $total['nonapproved'];
$dateX[0]=strftime($param['short_date_format'], time());

// Create the graph. These two calls are always required
$graph = new Graph(600,220,'');
$graph->img->SetMargin(60,130,30,40);       
//color
$graph->SetColor(array(233,242,255));
$graph->SetMarginColor(array(233,242,255));
$graph->legend->Pos(0.01,0.2,"right","center");  

// Create the bar plots
$b1plot = new BarPlot($dataY1);
$b1plot->SetFillColor("orange");
$b1plot->SetLegend(getTranslateText('REP_H_APPROVED'));  
$b2plot = new BarPlot($dataY2);
$b2plot->SetFillColor("blue");
$b2plot->SetLegend(getTranslateText('REP_H_NONAPPROVED'));   
$gbplot = new GroupBarPlot(array($b1plot,$b2plot));


$graph->Add($gbplot);

$graph->SetScale("textlin");
//title
$graph->title->Set(getTranslateText('LEFTMENU_CURSAL'));
SetFont($graph->title, FF_ARIALUNI, FS_NORMAL, 10);
SetFont($graph->legend, FF_ARIALUNI, FS_NORMAL, 8);

//x
$graph->xaxis->SetTickLabels($dateX);    
SetFont($graph->xaxis, FF_ARIALUNI, FS_NORMAL, 8);

//y
$currency = getCurrencyTextType(DEFAULT_JOIN_CURRENCY);
$currency_text = (!empty($currency['cur_symbol'])) ? ($currency['cur_symbol'] . ' - ' . $currency['cur_alpha3']) : $currency['cur_alpha3'];
$graph->yaxis->title->Set($currency_text); 
$graph->yaxis->title->SetMargin(20); 
SetFont($graph->yaxis->title, FF_CURRENCY, FS_NORMAL, 9);
SetFont($graph->yaxis, FF_ARIALUNI, FS_NORMAL, 8);

// Display the graph
$graph->Stroke();


?>