<?php
// $Id: callback_sample.php 5 2008-12-12 05:55:19Z adgar $

require_once('callback.class.php');

class Sample_Callback extends Callback {    
    var $affiliater_id;
    var $product_id;    
    var $txn_id;
    var $amount;
    var $curreny_id;    
    var $is_recurring=false;
    var $country_id = 0;
    var $customer_id = 0;
    var $add_info;
    
    function Sample_Callback() {
        parent::start();       
        if (!isset($_REQUEST['amount'])) {
            $this->finish('Bad parameters');
        }
        //Product ID and Affiliater ID
        global $db, $param, $users_types;
        //set data from cookie
        if (isset($_COOKIE['user_id'])) {
            $aff_id = intval($_COOKIE['user_id']);
        }
        if (isset($_COOKIE['group_id'])) {
            $productid = intval($_COOKIE['group_id']);
        }
        if (isset($_COOKIE['country_code'])) {
            $this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($_COOKIE['country_code']));
        }
        //parse add_id and set aff_id, group_id
        if((isset($_GET['aff_id']) || isset($_POST['aff_id'])) && preg_match("/(\d+):(\d+):?(\w{2})?/", $_REQUEST['aff_id'], $matches)) {                               
            $aff_id = $matches[1];
            $productid = $matches[2]; 
            if (isset($matches[3]))
                $this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($matches[3]));                   	
        }
        //set aff_id
        if (isset($_POST['aff_id']) || isset($_GET['aff_id'])) {
            $aff_id = isset($_POST['aff_id']) ? intval($_POST['aff_id']) : intval($_GET['aff_id']);
        }
        //set group_id
        if (isset($_POST['group_id']) || isset($_GET['group_id'])) {
            $productid = isset($_POST['group_id']) ? intval($_POST['group_id']) : intval($_GET['group_id']);
        }            
        if (empty($aff_id) || empty($productid)) {
            $this->finish('Affiliater ID is empty');
        }
        //validate aff_id                        
        $rs = $db->query("SELECT id FROM $param[dbprefix]users WHERE (usertype=?) AND (id=?)", array($users_types['affiliater'], $aff_id));
        if($row = $rs->fetchRow(DB_FETCHMODE_ASSOC))
        {
            $this->affiliater_id = (int) $row['id'];
            $this->product_id = $productid;
        } else {
            $this->finish('Not Valid Affiliate Information');
        }
        //Transaction ID
        if (isset($_REQUEST['txn_id'])) {
            $this->txn_id = $_REQUEST['txn_id'];
        } else {
            $this->txn_id = transaction_create_unique_id();
        }
        //Transaction Curreny           
        if (isset($_REQUEST['cur'])) {
            $this->curreny_id = $db->getOne("SELECT cur_id FROM $param[dbprefix]currency WHERE cur_alpha3=?", array($_REQUEST['cur']));
        }
        if (empty($this->curreny_id)) $this->curreny_id = DEFAULT_JOIN_CURRENCY;
        //Transaction Amount
        $this->amount = abs($_REQUEST['amount']);   
        //Recurring  Transaction
        if (isset($_REQUEST['recurring']) && !empty($_REQUEST['recurring'])) {
            $this->is_recurring = true;
        }
        //Country Id
        if (isset($_REQUEST['country_code'])) {
            $this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($_REQUEST['country_code']));
        }
        //Customer Id
        if (isset($_REQUEST['customer_id'])) {
            $this->customer_id = intval($_REQUEST['customer_id']);
        }
        
        return;
    }
    
    function deposit() {
        $approved = (int)getParamByName('auto_approve_new_transaction'); 
        transaction_log($this->txn_id);
        $credit_result = transaction_credit_primary($this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'], $this->product_id, $this->customer_id, $this->country_id, $this->add_info, $approved, false, $this->is_recurring);
        if (true == $credit_result[0]) {
            $mail_template_param = array(
                'TransactionAmount'=> moneytextformat($credit_result[2], $credit_result[3])
            );            
            sendAdminMailFromTemplate('admtransaction', $this->affiliater_id, $mail_template_param);
            $record_id = $credit_result[1];
            $return = 'Transaction is successfully added';
            if (1 == $approved) {
                sendUserMailFromTemplate('transaction', $this->affiliater_id, $mail_template_param);
                $credit_secondary_depth = (int)getParamByName('credit_secondary_depth'); 
                $credit_result = transaction_credit_secondary($record_id, '', $credit_secondary_depth, 0);
                if (false == $credit_result[0]) $return .=  "\n".get_transaction_error($credit_result[1]);
            }            
        } else $return = get_transaction_error($credit_result[1]);       
        
    	return $return;
    }
    
    function refund() {
        transaction_log($this->txn_id);
        $refund_result = transaction_refund($_REQUEST['orig_id'], $this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'],  $this->add_info);
        if (true == $refund_result[0]) $return = 'Chargeback transaction is successfully added';  
        else $return =  get_transaction_error($refund_result[1]); 
        
        return $return;
    }
    
    function finish($str_status) {
        parent::finish($str_status);        
        echo "OK\n" . $str_status;    
        exit();
    }    
}

$Sample_Callback = new Sample_Callback();

if (isset($_REQUEST['orig_id'])) {
    $Sample_Callback->add_info = 'Chargeback';
    $return = $Sample_Callback->refund();
} else {
    $Sample_Callback->add_info = isset($_REQUEST['add_info']) ? urldecode($_REQUEST['add_info']) : '';    
    $return = $Sample_Callback->deposit();
}

$Sample_Callback->finish($return);
  
?>