<?php
// $Id: callback_paypal_ipn.php 5 2008-12-12 05:55:19Z adgar $

require_once('callback.class.php');

class PAYPAL_Callback extends Callback {    
    var $affiliater_id;
    var $product_id;    
    var $txn_id;
    var $amount;
    var $curreny_id;
    var $is_recurring;
    var $country_id = 0;
    var $add_info;
        
    function PAYPAL_Callback() {
        parent::start();        
//        $data_verifited = true;
        $data_verifited = $this->verified();
        if ($data_verifited) {         
            //Product ID and Affiliater ID
            global $db, $param, $users_types;
            if (preg_match("/(\d+):(\d+):?(\w{2})?/", $_POST['custom'], $matches)) {
            	$aff_id = $matches[1];
            	$productid = $matches[2]; 
            	if (isset($matches[3]))
                	$this->country_id = (int) $db->getOne("SELECT cnumber FROM $param[dbprefix]countries WHERE ccode=? LIMIT 0,1", array($matches[3]));   
            }
            $rs = $db->query("SELECT id FROM $param[dbprefix]users WHERE (usertype=?) AND (id=?)", array($users_types['affiliater'], $aff_id));
            if($row = $rs->fetchRow(DB_FETCHMODE_ASSOC))
            {
                $this->affiliater_id = intval($row['id']);
                $this->product_id = $productid;
            } else {
                $return="Not Valid Affiliate Information";    
            }
            //Transaction Curreny
            $this->curreny_id = $db->getOne("SELECT cur_id FROM $param[dbprefix]currency WHERE cur_alpha3=?", array($_POST['mc_currency']));
            if (empty($this->curreny_id)) $this->curreny_id = DEFAULT_JOIN_CURRENCY;
            
            //Transaction Type
            switch ($_POST['txn_type']) {
               case 'subscr_signup': 
                 $return = 'This IPN is for a subscription sign-up.';               
                 break;
               case 'subscr_cancel':                
                 $return = 'This IPN is for a subscription cancellation.';               
                 break;
               case 'subscr_failed':                
                 $return = 'This IPN is for a subscription payment failure.';               
                 break;
               case 'subscr_payment':                
                 $this->is_recurring = true;
                 $this->add_info = 'This IPN is for a subscription payment.';
                 break;                                   
               case 'subscr_eot':                
                 $return = 'This IPN is for a subscription\'s end-of-term.';               
                 break;                     
               case 'subscr_modify':                
                 $return = 'This IPN is for a subscription modification.';               
                 break;     
               case 'web_accept':                
               case 'cart':
               case 'send_money':
               if ('Completed' != $_POST['payment_status'])
                 $return = 'Current transaction status ($_POST[payment_status]) not \'Completed\'.';
                 break;                                     
            }       
            
            //Transaction Amount && Transaction ID
            $this->amount = abs($_POST['mc_gross']);
            $this->txn_id = $_POST['txn_id'];            

        } else {
            $return = 'Data not verifited';
        }
              
        
        if (!empty($return)) { 
            $this->finish($return);
        }
        return;         
    }
    
    function verified() {
    	// read the post from PayPal system and add 'cmd'
    	$req = 'cmd=_notify-validate';    
    	foreach ($_POST as $key => $value) {
    		
    		if (get_magic_quotes_gpc()) {
    			$value = stripslashes($value);
    		}
    		$value = urlencode($value);
    		$req .= "&$key=$value";		
    	}
    	// post back to PayPal system to validate
    	$header .= "POST /cgi-bin/webscr HTTP/1.0\r\n";
    	$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
    	$header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
        
    	$VERIFIED = false;	
    	$fp = fsockopen ('ssl://www.paypal.com', 443, $errno, $errstr, 30);
    	if ($fp) {
    		fputs ($fp, $header . $req); // post to paypal
    		while (!feof($fp)) {
    		  $res = fgets ($fp, 1024);
    		  if (strcmp ($res, "VERIFIED") == 0) {
    		      $VERIFIED = true;
    		      break;
    		  }
    		}
    	   fclose ($fp);	
    	}
    	
    	return $VERIFIED;
    }
    
    function deposit() {
        $approved = (int)getParamByName('auto_approve_new_transaction'); 
        transaction_log($this->txn_id);
        $credit_result = transaction_credit_primary($this->txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'], $this->product_id, 0, $this->country_id,  $this->add_info, $approved, false, $this->is_recurring);
        if (true == $credit_result[0]) {
            $mail_template_param = array(
                'TransactionAmount'=> moneytextformat($credit_result[2], $credit_result[3])
            );            
            sendAdminMailFromTemplate('admtransaction', $this->affiliater_id, $mail_template_param);
            $record_id = $credit_result[1];
            $return = 'Transaction is successfully added';
            if (1 == $approved) {
                sendUserMailFromTemplate('transaction', $this->affiliater_id, $mail_template_param);
                $credit_secondary_depth = (int)getParamByName('credit_secondary_depth'); 
                $credit_result = transaction_credit_secondary($record_id, '', $credit_secondary_depth, 0);
                if (false == $credit_result[0]) $return .=  "\n".get_transaction_error($credit_result[1]);
            }            
        } else $return = get_transaction_error($credit_result[1]);       
        
    	return $return;
    }
    
    
    function refund() {
        $this->add_info = "Chargeback";
        $txn_id = transaction_create_unique_id();
        transaction_log($txn_id );
        $refund_result = transaction_refund($this->txn_id, $txn_id, $this->amount, $this->curreny_id, $this->affiliater_id, $_SERVER['REMOTE_ADDR'],  $this->add_info);
        if (true == $refund_result[0]) $return = 'Chargeback transaction is successfully added';  
        else $return =  get_transaction_error($refund_result[1]); 
        
        return $return;
    }
        
    function finish($str_status) {
        parent::finish($str_status);        
        echo "OK\n" . $str_status;    
        exit();
    }    
}

$PAYPAL_Callback = new PAYPAL_Callback();
if (('Refunded' == $_POST['payment_status']) || ('reversal' == $_POST['txn_type'])) {
    $return = $PAYPAL_Callback->refund();
} else {
    $return = $PAYPAL_Callback->deposit();
}

$PAYPAL_Callback->finish($return);
 
?>