<?php
// $Id: statistics.php 5 2008-12-12 05:55:19Z adgar $

require_once('cfg.php');   
checkAccess('AFF');
require_once('reporter.inc.php');

$h3header = getTranslateText(9);
starting($h3header);
updateLastviewed($_SESSION['userid'], $param['selfname'], '9');

$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"account.php","name"=>getTranslateText(7));
$items[] = array("icon"=>"cases.gif","location"=>"statistics.php","name"=>getTranslateText(9));
$items[] = array("icon"=>"cases.gif","location"=>"traffic.php","name"=>getTranslateText(8));
$items[] = array("icon"=>"cases.gif","location"=>"payout_history.php", "name"=>getTranslateText(38));
submenu($items);

$tmp_tpl_filename = getTemplateFullPath('_tr_filter.html');
insertTransactionFilter('filterfile', $tmp_tpl_filename, 'template.transactions_filter');
$sql_q = getTransactionFilterSqlCondition();

$cur_report = new Reporter('aff_statistics.rep.php', $sql_q);
$xtpl->assign('cur_report', $cur_report->toHtml(true, '2csv.php', 'aff_statistics_csv.rep.php'));
$xtpl->parse('template.transactions');
       
/**
 * Total
 **/
$def_currency = "";
if ((!defined('DEFAULT_JOIN_CURRENCY') || !@intval(DEFAULT_JOIN_CURRENCY)) && isset($_SESSION['userid'])) {
    $def_currency = $db->getOne("SELECT currencyid FROM $param[dbprefix]withdraw_users WHERE affiliateid=?", array($_SESSION['userid']));
} 

if (!$def_currency) {
    $def_currency = getParamByName('def_join_currency');
}

$sql = "
SELECT 
SUM(IF(((t1.txn_type={$transaction_types['credit_primary']} AND t1.is_recurring=0) OR t1.txn_type={$transaction_types['credit_initial_bonus']}), TRUNCATE(t2.factor_value * t1.amount,2), 0)) as credit_primary,
SUM(IF(((t1.txn_type={$transaction_types['credit_primary']} AND t1.is_recurring=1) OR t1.txn_type={$transaction_types['credit_recurring']}), TRUNCATE(t2.factor_value * t1.amount,2), 0)) as credit_recurring,
SUM(IF((t1.txn_type={$transaction_types['credit_secondary']}), TRUNCATE(t2.factor_value * t1.amount,2), 0)) as credit_secondary,
SUM(IF((t1.txn_type={$transaction_types['credit_tfaffic']}), TRUNCATE(t2.factor_value * t1.amount,2), 0)) as credit_tfaffic,
SUM(IF((t1.txn_type={$transaction_types['debit_chargeback']}), TRUNCATE(t2.factor_value * t1.amount,2), 0)) as debit_chargeback,
SUM(IF((t1.txn_type={$transaction_types['debit_payout']}), TRUNCATE(t2.factor_value * t1.amount,2), 0)) as debit_payout
FROM  $param[dbprefix]transactions as t1
LEFT JOIN $param[dbprefix]currency_factors as t2
ON (t1.orig_cur_index = t2.cur_from AND t2.cur_to = " . intval($def_currency). ")
WHERE user_id=? AND approved=1
"; 

$rs = $db->getRow($sql, array($_SESSION['userid']));

foreach($rs as $k => $v) {
    if ($v == 0) {
    	continue;
	}
    $xtpl->assign('type', getTransactionTextType($transaction_types[$k]));
    $xtpl->assign('amount', moneytextformat($v, $def_currency));
    $xtpl->parse('template.sales_total.transaction_info');
}
$xtpl->assign('type', '<strong>' . getTranslateText('TT_EARNINGS') . '</strong>');
$foo = array_sum($rs); 
$xtpl->assign('amount', '<strong>' . moneytextformat($foo, $def_currency) . '</strong>');
$xtpl->parse('template.sales_total.transaction_info');
$xtpl->parse('template.sales_total');
/*
echo $sql; die();
$rs = $db->query($sql, $_SESSION['userid']);
$total = array(
'credit_primary' => 0,
'credit_recurring' => 0,
'credit_secondary' => 0,  
'credit_tfaffic' => 0,
'debit_chargeback' => 0,
'debit_payout' => 0,
);
$cid = DEFAULT_JOIN_CURRENCY;
while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
    $total['credit_primary'] += moneyConvert($row['primary_txn'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    $total['credit_recurring'] += moneyConvert($row['recurring_txn'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    $total['credit_secondary'] += moneyConvert($row['second_txn'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    $total['credit_tfaffic'] += moneyConvert($row['traffic_txn'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    $total['debit_chargeback'] += moneyConvert($row['chargeback_txn'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    $total['debit_payout'] += moneyConvert($row['payout_txn'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
}
foreach($total as $k => $v) {
    if ($v == 0) continue;
    $xtpl->assign('type', getTransactionTextType($transaction_types[$k]));
    $xtpl->assign('amount', moneytextformat($v, DEFAULT_JOIN_CURRENCY));
    $xtpl->parse('template.sales_total.transaction_info');
}
$xtpl->assign('type', '<strong>' . getTranslateText('TT_EARNINGS') . '</strong>');
$foo = array_sum($total); 
$xtpl->assign('amount', '<strong>' . moneytextformat($foo, DEFAULT_JOIN_CURRENCY) . '</strong>');
$xtpl->parse('template.sales_total.transaction_info');
$xtpl->parse('template.sales_total');
 */
/**
* Chart
**/
$xtpl->assign('CHART', "aff_det_stat.php?f=" . urlencode(base64_encode($sql_q)));
if (isset($_REQUEST['active_filter']) && is_array($_REQUEST['active_filter'])) {
    if (in_array('date_from', $_REQUEST['active_filter']))
        $xtpl->assign('CHART', "aff_det_stat.php?from=$_REQUEST[filter_date_from]&to=$_REQUEST[filter_date_to]&f=" . urlencode(base64_encode($sql_q)));
}

ending();
?>