<?php
// $Id: cfg.php 12 2009-08-06 04:53:53Z adgar $

/******************************    
* Initialization
 ******************************/ 
$os = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 'win' : 'nix';
if ('win' == $os) {
    if (!defined('DIRECTORY_SEPARATOR'))  define('DIRECTORY_SEPARATOR', '\\');
    if (!defined('PATH_SEPARATOR'))  define('PATH_SEPARATOR', ';');
    if (!defined('PHP_SHLIB_SUFFIX'))  define('PHP_SHLIB_SUFFIX', 'dll');
    if (!isset($_SERVER['QUERY_STRING'])) $_SERVER['QUERY_STRING'] = '';    
    if (strstr($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS')) $_SERVER['REQUEST_URI'] = $_SERVER['PATH_INFO'] . '?' . $_SERVER['QUERY_STRING'];	
} else {
    if (!defined('DIRECTORY_SEPARATOR'))  define('DIRECTORY_SEPARATOR', '/');
    if (!defined('PATH_SEPARATOR'))  define('PATH_SEPARATOR', ':');    
    if (!defined('PHP_SHLIB_SUFFIX'))  define('PHP_SHLIB_SUFFIX', 'so');
}

$absbase = realpath(dirname(__FILE__) . '/../');
$include_path = array(
  './',
  $absbase,        
  $absbase . '/config',
  $absbase . '/lib',
  $absbase . '/include'
);

ini_set('include_path', implode(PATH_SEPARATOR, $include_path));
unset($os, $absbase);

/******************************    
* Include core libraries
 ******************************/
require_once('common.inc.php');
if (!defined('DEFAULT_JOIN_CURRENCY') && isset($_SESSION['userid'])) {
    $def_currency = $db->getOne("SELECT currencyid FROM $param[dbprefix]withdraw_users WHERE affiliateid=?", array($_SESSION['userid']));
    define('DEFAULT_JOIN_CURRENCY', $def_currency);
} else {
    define('DEFAULT_JOIN_CURRENCY', getParamByName('def_join_currency'));
}

/*************************************
* @Set templates path
*
**************************************/
define('TPL_FOLDER', 'affiliate');

/**
 * Detecting affiliater link code
 */
if (isset($_REQUEST['ref'])) {
    set_cookie('aff_findertextid', $_REQUEST['ref']);
    $_SESSION['aff_findertextid'] = $_REQUEST['ref'];
}

if (isset($_REQUEST['joinlevel'])) {
    set_cookie('aff_joinlevel', $_REQUEST['joinlevel']);
    $_SESSION['aff_joinlevel'] = $_REQUEST['joinlevel'];
}

$base = HTTP_ADDR . 'affiliate';
$base1 = rtrim(HTTP_ADDR, '\\/');

/**
 * Tab items
 */
$tab_items = array();
$tab_items[] = array('tab_intex'=> 1, 'translate_key' =>  'TOPTAB_AFF_MENU_GENERAL', 'location' => 'index.php');
$tab_items[] = array('tab_intex'=> 2, 'translate_key' =>  'TOPTAB_AFF_MENU_ACTIVITY', 'location' => 'account.php');
$tab_items[] = array('tab_intex'=> 3, 'translate_key' =>  'TOPTAB_AFF_MENU_LINK_CODE', 'location' => 'links.php?type=imgban');
$tab_items[] = array('tab_intex'=> 4, 'translate_key' =>  'TOPTAB_AFF_MENU_DETAILS', 'location' => 'details.php');

$cur_tab_list = array(
    1 => array('affiliate.php', 'index.php', 'join.php', 'login.php', 'logout.php', 'news.php', 'products.php', 'termsofuse.php', 'tickets.php'),
    2 => array('account.php', 'statistics.php', 'payout_history.php', 'traffic.php', 'traffic_info.php', 'transaction_info.php'),
    3 => array('links.php', 'tiercode.php'),
    4 => array('password.php', 'details.php','tiers.php')
);


?>