<?php
// $Id: quick_stats_csv.php 5 2008-12-12 05:55:19Z adgar $

require_once('transactionbuilder.inc.php');
require_once('AffPro/CSV.class.php');

$foo_csv = new CSV();
$foo_csv->send_headers('quick_stats.csv');
$captions = array(
0 => array(
	getTranslateText('PERORT_HEADER1')
	)
);
$foo_csv->add($captions);
$captions = array(
0 => array(
	getTranslateText('REP_H_DATE'), 
	getTranslateText('TXNTYPE_SALESCOMISSION'), 
	getTranslateText('TXNTYPE_TIERCOMISSION'), 
	getTranslateText('TXNTYPE_INITIALBONUS'), 
	getTranslateText('TXNTYPE_CHARGEBACK'), 
	getTranslateText('TXNTYPE_PAYOUT'), 
	getTranslateText('TXNTYPE_TRAFFIC')
	)
);
$foo_csv->add($captions);

$rs = $db->query("SELECT t1.txn_type, sum(t1.orig_amount) as orig_amount, sum(t1.amount) as amount, t1.orig_cur_index, t1.daily_number, t1.weekly_number, t1.bi_weekly_number, t1.monthly_number, t1.half_monthly_number FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 $sql_q ORDER BY t1.create_date DESC", null, DB_FETCHMODE_ASSOC);

if (0 != $rs->numRows()) {
    $report_data1 = array();
    switch (intval($_REQUEST['filter_txn_period'])) {
        case $date_period_types['daily_number']: 
        $period_key = 0;
        break;        
        case $date_period_types['weekly_number']: 
        $period_key = 1;
        break;        
        case $date_period_types['bi_weekly_number']: 
        $period_key = 2;
        break;        
        case $date_period_types['half_monthly_number']: 
        $period_key = 4;
        break;        
        default: 
        $period_key = 3;        
        break;
    }
    
    $cell_name = array_search($period_key, $date_period_types);
    while($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $key_one = $row[$cell_name];
        $key_two = $row['txn_type']; 
        $report_data1[$key_one][$key_two] = moneyConvert($row['amount'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    }
   $total = array();
    
//    $report_data1
    $interval_keys = array_keys($report_data1);   
    $interval_str = getFormatStrInterval($period_key, $interval_keys);
    
    //print data
    foreach ($report_data1 as $period_key => $data) {
        $csv_string = array(
        0 => array(
        	$interval_str[$period_key], 
        	moneytextformat($data[0], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($data[1], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($data[2], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($data[5], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($data[7], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($data[9], DEFAULT_JOIN_CURRENCY)
        	)
        );
        $foo_csv->add($csv_string);
    }
    //total
    if (0 != count($total)) {
        $csv_string = array(
        0 => array(
        	getTranslateText('REP_H_TOTAL'), 
        	moneytextformat($total[0], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($total[1], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($total[2], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($total[5], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($total[7], DEFAULT_JOIN_CURRENCY), 
        	moneytextformat($total[9], DEFAULT_JOIN_CURRENCY)
        	)
        );
		$foo_csv->add($captions);
           
    }          
}
else {
	$foo_csv->add(array(
	0 =>getTranslateText('NORECORD_TXN'))
	);
}
// Let's send the file
$foo_csv->show();
?>