<?php
// $Id: cur_sales_csv.php 5 2008-12-12 05:55:19Z adgar $

require_once('AffPro/CSV.class.php');

$description1 = getTranslateText('LEFTMENU_CURSAL', PRIMARY_LANGUAGE);

$foo_csv = new CSV();

$foo_csv->send_headers('current_sales.csv');

$captions = array(
0 => array(
	$description1
	), 
1 => array(
	getTranslateText('REP_H_USERNAME'), 
	getTranslateText('REP_H_APPROVED'), 
	getTranslateText('REP_H_NONAPPROVED'), 
	getTranslateText('REP_H_TOTAL')
	)
);
$foo_csv->add($captions);

$rs = $db->query("SELECT id as user_id, name as user_name FROM $param[dbprefix]users as t2 WHERE (t2.approved=1) AND (t2.usertype=?) $sql_q", array($users_types['affiliater']), DB_FETCHMODE_ASSOC);       

if (0 < $rs->numRows()) {
	$rs_app = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 INNER JOIN $param[dbprefix]users as t2 ON (t1.user_id=t2.id) WHERE (t2.usertype=?) AND (t1.approved=1) AND (t2.approved=1) $sql_q GROUP BY t1.user_id, t1.orig_cur_index", false, array($users_types['affiliater']), DB_FETCHMODE_ASSOC, true);
    $rs_noapp = $db->getAssoc("SELECT t1.user_id, sum(t1.amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 INNER JOIN $param[dbprefix]users as t2 ON (t1.user_id=t2.id) WHERE (t2.usertype=?) AND (t1.approved=0) AND (t2.approved=1) $sql_q GROUP BY t1.user_id, t1.orig_cur_index", false, array($users_types['affiliater']), DB_FETCHMODE_ASSOC, true);

    while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC) ) { 
    	$i++;
        $key_one = $row['user_id']; 
        $app_amount = $nonapp_amount = $total_amount = '';
	    $total = array(
	        'approved' =>  array(),
	        'nonapproved' =>  array(),
	        'total' =>  array()
	    );
	    $total_app_link =& $total['approved'];    
	    $total_noapp_link =& $total['nonapproved'];    
	    $total_link =& $total['total'];      
        //approved amount for current affiliater
        if (isset($rs_app[$key_one])) {
        	$transactions =& $rs_app[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $key_two = $transactions[$k]['orig_cur_index'];
	            $total_app_link[$key_two] += $transactions[$k]['amount'];              
	            $total_noapp_link[$key_two] += 0;
	            $total_link[$key_two] += $transactions[$k]['amount']; 
                            
            }
    	}            
	    foreach ($total_app_link as $orig_cur_index => $amount) {
	        $app_amount .= moneytextformat($amount, $orig_cur_index) . "\n";
	    }                  	
		if (!$app_amount) {
			$app_amount = moneytextformat("0", DEFAULT_JOIN_CURRENCY);
		}	    
        //nonapproved amount for current affiliater
        if (isset($rs_noapp[$key_one])) {
            $transactions =& $rs_noapp[$key_one];
            for($k=0, $max=count($transactions); $k<$max; $k++) {
                $key_two = $transactions[$k]['orig_cur_index'];
	            $total_noapp_link[$key_two] += $transactions[$k]['amount'];              
	            $total_app_link[$key_two] += 0;
	            $total_link[$key_two] += $transactions[$k]['amount'];              
            }
        }
	    foreach ($total_noapp_link as $orig_cur_index => $amount) {
	        $nonapp_amount .= moneytextformat($amount, $orig_cur_index) . "\n";
		}
		if (!$nonapp_amount) {
			$nonapp_amount = moneytextformat("0", DEFAULT_JOIN_CURRENCY);
		}		
        //total_amount for current affiliater    
	    foreach ($total_link as $orig_cur_index => $amount) {
	        $total_amount .= moneytextformat($amount, $orig_cur_index) . "\n";
	    }  
		if (!$total_amount) {
			$total_amount = moneytextformat("0", DEFAULT_JOIN_CURRENCY);
		}		
		unset($transactions, $total_app_link, $total_noapp_link, $total_link);             
        $foo_row = array(
        0 => array(
        	trim($row['user_name']), 
        	trim($app_amount), 
        	trim($nonapp_amount), 
        	trim($total_amount)
        	)
        );
        $foo_csv->add($foo_row);
    }
    
    
    //total   
    $app_amount = $nonapp_amount = $total_amount = '';
    $total = array(
        'approved' =>  array(),
        'nonapproved' =>  array(),
        'total' =>  array()
    );
    $total_app_link =& $total['approved'];    
    $total_noapp_link =& $total['nonapproved'];    
    $total_link =& $total['total'];        
    
    //approved amount for all affiliaters
    foreach ($rs_app as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {
            $key_two = $transactions[$k]['orig_cur_index'];
            $total_app_link[$key_two] += $transactions[$k]['amount']; 
            $total_noapp_link[$key_two] += 0;             
            $total_link[$key_two] += $transactions[$k]['amount'];            
        }
    }       
    foreach ($total_app_link as $orig_cur_index => $amount) {
        $app_amount .= moneytextformat($amount, $orig_cur_index) . "\n";
    }    

    //nonapproved amount for all affiliaters 
    foreach ($rs_noapp as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {
            $key_two = $transactions[$k]['orig_cur_index'];
            $total_noapp_link[$key_two] += $transactions[$k]['amount'];
            $total_app_link[$key_two] += 0;              
            $total_link[$key_two] += $transactions[$k]['amount'];
        }
    }
    foreach ($total_noapp_link as $orig_cur_index => $amount) {
        $nonapp_amount .= moneytextformat($amount, $orig_cur_index) . "\n";
    }    
    //total_amount for all affiliaters   
    foreach ($total_link as $orig_cur_index => $amount) {
        $total_amount .= moneytextformat($amount, $orig_cur_index) . "\n";
    }  
    unset($total_app_link, $total_noapp_link, $total_link);       
    //assign and parse data  
    $i ++; 
	$foo_total = array(
	0 => array(
			getTranslateText('TT_ALL_AFF'), 
			trim($app_amount), 
			trim($nonapp_amount), 
			trim($total_amount)
		)
	);
	$foo_csv->add($foo_total);
	
}
else {
	$foo_csv->add(
	array(
		0 => getTranslateText('NORECORD_TXN'), 
		)
	);

}
$foo_csv->show();
?>