<?php
// $Id: quick_stats.php 5 2008-12-12 05:55:19Z adgar $

require_once('admincfg.php');   
require_once('filters.inc.php');
require_once('htmlelements.inc.php');
require_once('transactionbuilder.inc.php');
require_once('AffPro/Reporter.class.php');

starting(getTranslateText('TT_QUICK_STATS'));
updateLastviewed($_SESSION['userid'], $param['selfname'], 'TT_QUICK_STATS');

$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"quick_stats.php", "name"=>getTranslateText('TT_QUICK_STATS'));
$items[] = array("icon"=>"cases.gif","location"=>"traffic.php","name"=>getTranslateText(8));
$items[] = array("icon"=>"cases.gif","location"=>"payout_history.php", "name"=>getTranslateText(38));
$items[] = array("icon"=>"cases.gif","location"=>"ppc_stats.php", "name"=>getTranslateText('TT_PROFIT_PER_CLICK'));
$items[] = array("icon"=>"cases.gif","location"=>"affiliate_stats.php", "name"=>getTranslateText('TT_AFF_STATS'));
$items[] = array("icon"=>"cases.gif","location"=>"product_stats.php", "name"=>getTranslateText('TT_PRODUCT_STATS'));
//$items[] = array("icon"=>"cases.gif","location"=>"impressions_stats.php", "name"=>getTranslateText('TT_IMPRESSIONS_STATS'));
$items[] = array("icon"=>"cases.gif","location"=>"country_stats.php", "name"=>getTranslateText('TT_COUNTRY_STATS'));
submenu($items);

$tmp_tpl_filename = getTemplateFullPath('_quickstat_filter.html');
insertQickStatsFilter('filterfile', $tmp_tpl_filename, 'template.quickstat_filter');
$sql_q = getQickStatsFilterSqlCondition();

//$xtpl->assign('sql_filter', urlencode(base64_encode($sql_q)));
//$xtpl->assign('report_filename', urlencode(base64_encode('quick_stats')));
$xtpl->assign('sql_filter', Reporter::base64_encode_special($sql_q));
$xtpl->assign('report_filename_export', Reporter::base64_encode_special('quick_stats_csv'));
$xtpl->assign('report_filename_print', Reporter::base64_encode_special('quick_stats'));
$xtpl->assign('filter_txn_period', isset($_REQUEST['filter_txn_period']) ? $_REQUEST['filter_txn_period'] : $date_period_types['monthly_number']);
    
$rs = $db->query("SELECT t1.txn_type, sum(t1.orig_amount) as orig_amount, sum(t1.amount) as amount, t1.orig_cur_index, t1.daily_number, t1.weekly_number, t1.bi_weekly_number, t1.monthly_number, t1.half_monthly_number FROM $param[dbprefix]transactions as t1 WHERE t1.approved=1 $sql_q ORDER BY t1.create_date DESC", null, DB_FETCHMODE_ASSOC);

if (0 == $rs->numRows()) {
    $xtpl->parse('template.no_records');        
} else {
    $report_data1 = array();
    switch (intval($_REQUEST['filter_txn_period'])) {
        case $date_period_types['daily_number']: 
        $period_key = 0;
        break;        
        case $date_period_types['weekly_number']: 
        $period_key = 1;
        break;        
        case $date_period_types['bi_weekly_number']: 
        $period_key = 2;
        break;        
        case $date_period_types['half_monthly_number']: 
        $period_key = 4;
        break;        
        default: 
        $period_key = 3;        
        break;
    }
    
    $cell_name = array_search($period_key, $date_period_types);
    while($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $key_one = $row[$cell_name];
        $key_two = $row['txn_type']; 
        $report_data1[$key_one][$key_two] = moneyConvert($row['amount'], $row['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
    }
   $total = array();
    
    $interval_keys = array_keys($report_data1);   
    $interval_str = getFormatStrInterval($period_key, $interval_keys);
    
	$R = 1;
    foreach ($report_data1 as $period_key => $data) {
        $xtpl->assign('date_period', $interval_str[$period_key]);
        foreach ($transaction_types as $k => $v) {            
            $xtpl->assign("col_$v", moneytextformat($data[$v], DEFAULT_JOIN_CURRENCY));
            $total["total_col_$v"] += floatval($data[$v]);
        }
		$R = ($R || 1) && (!$R || 0);
		$xtpl->assign('R', $R + 1);
        $xtpl->parse('template.quickstat.loop');            
    }
    //total
    if (0 != count($total)) {
        foreach ($total as $k => $v)          
            $xtpl->assign($k, moneytextformat($v, DEFAULT_JOIN_CURRENCY));
		$R = ($R || 1) && (!$R || 0);
		$xtpl->assign('R', $R + 1);
        $xtpl->parse('template.quickstat.total');
    }

    $xtpl->parse('template.quickstat');        
}

$xtpl->assign('CHART', 'admin_quick_stats.php');

ending();
?>