<?php
// $Id: pay.php 5 2008-12-12 05:55:19Z adgar $

require_once('admincfg.php');   
require_once('transactionbuilder.inc.php');
require_once('htmlelements.inc.php');

if (!isset($_REQUEST['uid']) || !is_numeric($_REQUEST['uid'])) {
    AFFPRO::redirect($base . '/aff_pay.php');
}

$rs_app = $db->getAssoc("SELECT t1.orig_cur_index, sum(t1.amount) as amount  FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND (t1.user_id=?) GROUP BY t1.user_id, t1.orig_cur_index HAVING sum(t1.amount) > 0", false, array(intval($_REQUEST['uid'])), DB_FETCHMODE_ASSOC);

if (isset($_REQUEST['action'])) {
    if ('pay' == $_REQUEST['action']) {
        $total_amount = $incomplete_pay = 0;
        foreach ($_POST['payout'] as $orig_cur_index => $amount) {            
            $pay_amount = str_replace(',', '.', $amount);
            $pay_amount = floatval($pay_amount);
            if ($pay_amount > $rs_app[$orig_cur_index]) $pay_amount = $rs_app[$orig_cur_index];
            $incomplete_pay += ($pay_amount == $rs_app[$orig_cur_index]) ? 0 : 1;
            if (!empty($pay_amount)) {
                $orig_tnx_id = transaction_create_unique_id();
                $debit_result = transaction_debit_paid($orig_tnx_id, (-1)*$pay_amount, $orig_cur_index, $_REQUEST['uid']);

                if (true == $debit_result[0]) {
                    $total_amount += moneyConvert($debit_result[2], $debit_result[3], DEFAULT_JOIN_CURRENCY);
                }
            }          
        }
        if (0 != $total_amount) {
            $mail_template_param = array(
                'ComissionAmount'=> moneytextformat($total_amount, DEFAULT_JOIN_CURRENCY)
            );        
            sendUserMailFromTemplate('commisionpayment', $_REQUEST['uid'], $mail_template_param);                            
        }
        AFFPRO::redirect((0 != $incomplete_pay) ? "$base/$param[selfname]?uid=$_REQUEST[uid]" : "$base/aff_pay.php?user=affiliater");                
    } elseif ('updatefactors' == $_REQUEST['action']) {
        updateAllConvertFactors();
        AFFPRO::redirect($base . "/$param[selfname]?uid=$_REQUEST[uid]");
    }

}

$user_rs = $db->query("SELECT t1.id as user_id, t1.usertype as usertype, t1.name as username, t2.currencyid as user_cur_id, t3.caption as withdraw_name FROM  $param[dbprefix]users as t1 LEFT JOIN $param[dbprefix]withdraw_users as t2 ON (t1.id=t2.affiliateid) LEFT JOIN $param[dbprefix]withdraw_type as t3 ON (t2.withdrawid=t3.id) WHERE (t1.id = ?)", array($_REQUEST['uid']));
if (!$user_info = $user_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
    AFFPRO::redirect($base . '/aff_pay.php');    
}

switch (intval($user_info['usertype'])) {  
    case $users_types['affiliater']: $headertext=getTranslateText(152);
         $user_type_text = getTranslateText(142);
            break;                             
}
starting($headertext);
updateLastviewed($_SESSION['userid'], $param['selfname'], '152');

$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"affiliates.php?user=affiliater","name"=>getTranslateText(21));
$items[] = array("icon"=>"cases.gif","location"=>"aff_app.php?user=affiliater","name"=>getTranslateText(22));
$items[] = array("icon"=>"cases.gif","location"=>"aff_pay.php?user=affiliater","name"=>getTranslateText(24));
$items[] = array("icon"=>"cases.gif","location"=>"tiers.php","name"=>getTranslateText(23));
submenu($items);      

/**
 * User Information
 */
foreach (array(
    'uid'=> $user_info['user_id'],
    'username' => $user_info['username'],
    'usertype' => $user_type_text
) as $k => $v) {
    $xtpl->assign($k, $v);
}
$xtpl->parse('template.user_info');

/**
 * Information about withdraw
 */
$withdray_rs=$db->query("SELECT t1.*, t2.caption FROM $param[dbprefix]withdraw_users as t1 LEFT JOIN  $param[dbprefix]withdraw_type t2 ON (t1.withdrawid=t2.id) WHERE (t2.active='1') AND (t1.affiliateid=?)", array($_REQUEST['uid']));   
$withdray=$withdray_rs->fetchRow(DB_FETCHMODE_ASSOC);
$xtpl->assign('TYPE', $withdray['caption']);
$xtpl->assign('CUR', getCurrencyTextType($withdray['currencyid'], true));
          
$tmp_tpl_filename = getTemplateFullPath('withdraw_forms.html');
$xtpl->assign_file("withdraw_forms", $tmp_tpl_filename);
$var_list = explode(getParamByName('separator_chars'),$withdray['variables']);

//country for withdraw
if ($withdray['withdrawid']=='1') {
    $country = $db->getOne("SELECT cname FROM $param[dbprefix]countries WHERE (lang_id=?) AND (cnumber=?)", array(getLanguageId(), $var_list[4]));
    $xtpl->assign("V14_CAPTION", $country); 
}
if ($withdray['withdrawid']=='2') {
    $country = $db->getOne("SELECT cname FROM $param[dbprefix]countries WHERE (lang_id=?) AND (cnumber=?)", array(getLanguageId(), $var_list[8]));
    $xtpl->assign("V28_CAPTION", $country); 
}

for ($i=0; $i < count ($var_list); $i++) {
     $xtpl->assign('V'.$withdray['withdrawid'].$i, nl2br($var_list[$i]));
}

$xtpl->parse("template.withdraw_info.withdraw_forms.viewform".$withdray['withdrawid']);
$xtpl->parse("template.withdraw_info.withdraw_forms");
$xtpl->parse("template.withdraw_info");

/**
 * Pay Information
 */
$xtpl->assign('bal_req', moneytextformat($bal_req, DEFAULT_JOIN_CURRENCY));

$hidden_data = getHiddenFieldHtmlCode('action', '');
$hidden_data .= getHiddenFieldHtmlCode('uid', $_REQUEST['uid']);    
$xtpl->assign('hidden_data', $hidden_data);
        
$payout = array();
$total_amount = $cnt = 0;
foreach ($rs_app as $orig_cur_index => $amount) 
    if ($amount > 0) {
        $convert_amount = moneyConvert($amount, $orig_cur_index, DEFAULT_JOIN_CURRENCY);
        $total_amount += $convert_amount;
        foreach (array(
        'R' => (($cnt++)%2==0) ? '1' : '2',  
        'payout' => getInputFieldHtmlCode("payout[$orig_cur_index]", moneytextformat($amount, 0, true), "style=\"width:100%;\" class=\"text\""),
        'currency' => getCurrencyTextType($orig_cur_index, true),
        'amount' => moneytextformat($amount, $orig_cur_index),
        'rate' => getConvertFactor($orig_cur_index, DEFAULT_JOIN_CURRENCY),
        'equivalent' => moneytextformat($convert_amount, DEFAULT_JOIN_CURRENCY),
        ) as $k => $v) {
            $xtpl->assign($k, $v);
        }
        $xtpl->parse('template.payouts.loop');        
    }   
$total_amount = moneytextformat($total_amount, DEFAULT_JOIN_CURRENCY);
$xtpl->assign('total_amount', $total_amount);
$xtpl->parse('template.payouts');

ending();
?>