<?php
// $Id: faq_editor.php 12 2009-08-06 04:53:53Z adgar $

require_once('admincfg.php');
require_once('htmlelements.inc.php');   
require_once('AffPro/FormChecker.class.php');  
$records = array('in_page'=>PAGER_PER_PAGE);  
$lang_id = getLanguageId();
$records['start'] = (isset($_REQUEST['entrant']) && (intval($_REQUEST['entrant']) > 0)) ? ((int)$_REQUEST['entrant'] - 1)*$records['in_page'] : 0;
$records['all'] = $db->getOne("SELECT count(*) FROM $param[dbprefix]faq WHERE lng_alpha2=?", array($lang_id), DB_FETCHMODE_ASSOC);       

$fc = new FormChecker('edit_form', true);
$foo = getTranslateText('TT_INVALID_FIELD_DATA') . " \"" . getTranslateText('TT_QUESTION') . "\"";
$fc->AddContent('question', $_REQUEST['question'], 'CHECK_NAME', $foo);
$foo = getTranslateText('TT_INVALID_FIELD_DATA') . " \"" . getTranslateText('TT_ANSWER') . "\"";
$fc->AddContent('answer', $_REQUEST['answer'], 'CHECK_NAME', $foo);
$html_before_body .= $fc->GetCheckerClass();
$html_before_body .= $fc->GetCheckingFunction();


if (isset($_REQUEST['action']) && ('publish_ticket' != $_REQUEST['action'])) {
    $faq_id = (is_numeric($_REQUEST['fid'])) ? $_REQUEST['fid'] : null;
    if (('add' != $_REQUEST['action']) && is_null($faq_id)) AFFPRO::redirect($base . "/$param[selfname]&entrant=$_REQUEST[entrant]");  
    
    switch ($_REQUEST['action']) {
    case 'update':
        $db->query("UPDATE $param[dbprefix]faq SET answer=?, question=? WHERE id=?", array($_REQUEST['answer'], $_REQUEST['question'], $faq_id));
        break;
    case 'add': 
        $pos = $db->getOne("SELECT IFNULL(MAX(pos)+1, 1) FROM $param[dbprefix]faq WHERE lng_alpha2=?", array($lang_id));
        $pos = $db->query("INSERT INTO $param[dbprefix]faq (pos, lng_alpha2, question, answer) VALUES (?, ?, ?, ?)", array($pos, $lang_id, $_POST['question'], $_POST['answer']));
        $_REQUEST['entrant'] = ceil(($records['all'] + 1) / $records['in_page']);
        break;
    case 'delete': 
        $pos = $db->getOne("SELECT pos FROM $param[dbprefix]faq WHERE id=? AND lng_alpha2=?", array($faq_id, $lang_id));
        $db->query("DELETE FROM $param[dbprefix]faq WHERE id=?", array($faq_id));
        $db->query("UPDATE $param[dbprefix]faq SET pos=(pos-1) WHERE pos>? AND lng_alpha2=?", array($pos, $lang_id));
        if (($records['all'] % $records['in_page']) == 1) $_REQUEST['entrant']--;
        break;
    case 'moveup': 
        $pos = $db->getOne("SELECT pos FROM $param[dbprefix]faq WHERE id=? AND lng_alpha2=?", array($faq_id, $lang_id));
        if ($pos > 1) {
            $db->query("UPDATE $param[dbprefix]faq SET pos=0 WHERE pos=? AND lng_alpha2=?", array($pos, $lang_id));
            $db->query("UPDATE $param[dbprefix]faq SET pos=pos+1 WHERE pos=? AND lng_alpha2=?", array($pos - 1, $lang_id));
            $db->query("UPDATE $param[dbprefix]faq SET pos=? WHERE id=? AND lng_alpha2=?", array($pos - 1, $faq_id, $lang_id));
            if ($pos > $records['in_page']) {
                $_REQUEST['entrant'] = ceil(($pos - 1) / $records['in_page']);
            }            
        }
        break;
    case 'movedown': 
        $pos = $db->getOne("SELECT pos FROM $param[dbprefix]faq WHERE id=? AND lng_alpha2=?", array($faq_id, $lang_id));
        $max_pos = $db->getOne("SELECT MAX(pos) FROM $param[dbprefix]faq WHERE lng_alpha2=?", array($lang_id));
        if ($pos < $max_pos) {
            $db->query("UPDATE $param[dbprefix]faq SET pos=0 WHERE pos=? AND lng_alpha2=?", array($pos, $lang_id));
            $db->query("UPDATE $param[dbprefix]faq SET pos=pos-1 WHERE pos=? AND lng_alpha2=?", array($pos + 1, $lang_id));
            $db->query("UPDATE $param[dbprefix]faq SET pos=? WHERE id=? AND lng_alpha2=?", array($pos + 1, $faq_id, $lang_id));
            if ($pos >= $records['in_page']) {
                $_REQUEST['entrant'] = ceil(($pos + 1) / $records['in_page']);
            }            
        }        
        break;
    }
    AFFPRO::redirect($base . "/$param[selfname]?entrant=$_REQUEST[entrant]");  
}

starting(getTranslateText('TT_FAQ_EDITOR'));
updateLastviewed($_SESSION['userid'], $param['selfname'], 'TT_FAQ_EDITOR');
$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"page_editor.php","name"=>getTranslateText('TT_PAGE_EDITOR'));
$items[] = array("icon"=>"cases.gif","location"=>$param['selfname'],"name"=>getTranslateText('TT_FAQ_EDITOR'));
$items[] = array("icon"=>"cases.gif","location"=>"color_editor.php","name"=>getTranslateText('TT_STYLES'));
submenu($items);   

$faq_rs = $db->query("SELECT * FROM $param[dbprefix]faq WHERE lng_alpha2=? ORDER BY pos LIMIT ?,?", array($lang_id, $records['start'], $records['in_page']));
if (0 == $faq_rs->numRows()) {
    $xtpl->parse("template.faq_edit.nodata");        
} else {
    $cnt = $records['start'];
    $xtpl->assign('entrant', intval($_REQUEST['entrant']));    
    while ($faq_row = $faq_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $xtpl->assign('fid', $faq_row['id']);
        $xtpl->assign('number', ++$cnt);
        $xtpl->assign('question', nl2br($faq_row['question']));
        $xtpl->assign('answer', nl2br($faq_row['answer']));
        $xtpl->parse('template.faq_edit.loop');
    }
    if ($records['all'] > $records['in_page']) {
        $pagerHtmlCode = getPagerHtmlCode($records['all'], $records['in_page'], null, true);
        $xtpl->assign('pager', $pagerHtmlCode);
        $xtpl->parse('template.faq_edit.pager');
    }    
}

$hidden_data = getHiddenFieldHtmlCode('action', 'add');
$hidden_data .= getHiddenFieldHtmlCode('fid');
if (isset($_REQUEST['entrant'])) $hidden_data .= getHiddenFieldHtmlCode('entrant', $_REQUEST['entrant']);
$xtpl->assign('hidden_data', $hidden_data);
if (isset($_REQUEST['action']) && ('publish_ticket' == $_REQUEST['action'])) {
        $def_answer = $def_question = '';
        $rs= $db->query("SELECT * FROM tickets_tickets as t1, tickets_status as t2 WHERE t1.tickets_category=t2.tickets_status_id AND t1.tickets_id=?", array($_REQUEST['ticketid']));
        $rs2= $db->query("SELECT * FROM tickets_tickets WHERE tickets_parent=? order by tickets_timestamp", array($_REQUEST['ticketid']));
        $row = $rs->fetchRow(DB_FETCHMODE_ASSOC);
        $def_question = $row['tickets_question'];
        while ($row = $rs2->fetchRow(DB_FETCHMODE_ASSOC)) {
            $def_answer .= $row['tickets_question'] . "\n\n";
        }                                                         
        $tmp = getInputFieldHtmlCode('question', $def_question, "class=\"text readonly\" style=\"width:99%;\" onfocus=\"onFocusIn();\" onblur=\"onFocusOut();\"");        
        $xtpl->assign('question', $tmp);        
        $tmp = getTextareaFieldHtmlCode('answer', $def_answer, "class=\"data readonly\" style=\"width:99%; height:80px; overflow:scroll;\" onfocus=\"onFocusIn();\" onblur=\"onFocusOut();\"");        
        $xtpl->assign('answer', $tmp);
} else {
    $tmp = getInputFieldHtmlCode('question', null, "class=\"text readonly\" style=\"width:99%;\" onfocus=\"onFocusIn();\" onblur=\"onFocusOut();\"");
    $xtpl->assign('question', $tmp);
    $tmp = getTextareaFieldHtmlCode('answer', null, "class=\"data readonly\" style=\"width:99%; height:120px; overflow:scroll;\" onfocus=\"onFocusIn();\" onblur=\"onFocusOut();\"");
    $xtpl->assign('answer', $tmp);
}

$xtpl->parse('template.faq_edit');

ending();
?>