<?php
// $Id: details.php 248 2007-12-06 12:47:03Z adgar $

include_once('admincfg.php');
require_once('lib/geoip.lib.php');
require_once('transactionbuilder.inc.php');

if (!isset($_REQUEST['id']) || !is_numeric($_REQUEST['id'])) {
    AFFPRO::redirect($base . "/affiliates.php");
}

$geoip = new GeoIP_Wrapper();

starting(getTranslateText(116));

$items = array();
$items[] = array("icon"=>"cases.gif","location"=>"affiliates.php?user=affiliater","name"=>getTranslateText(21));
$items[] = array("icon"=>"cases.gif","location"=>"aff_app.php?user=affiliater","name"=>getTranslateText(22));
$items[] = array("icon"=>"cases.gif","location"=>"aff_pay.php?user=affiliater","name"=>getTranslateText(24));
$items[] = array("icon"=>"cases.gif","location"=>"tiers.php","name"=>getTranslateText(23));
submenu($items);

/**
 * Information about user
 */
$user = $db->getRow("SELECT *, visit_time as last_login_time  FROM $param[dbprefix]users WHERE id=? LIMIT 0,1", array($_REQUEST['id']), DB_FETCHMODE_ASSOC);
$country = $db->getOne("SELECT cname FROM $param[dbprefix]countries WHERE cnumber=? AND lang_id=?", array($user['country'], getLanguageId()));
$country = $db->getOne("SELECT cname FROM $param[dbprefix]countries WHERE cnumber=? AND lang_id=?", array($user['country'], getLanguageId()));
switch ((int)$user['usertype']) {
   default: $users_types['affiliater'];
     $user_type = getTranslateText(142);
     break;
}

foreach (array(
	'R_USERTYPE'=>$user_type,
    'ID'=>$user['id'],

    'R_USERNAME'=>$user['name'],
    'R_PASSWORD'=>$user['password'],
    'R_REG_TIME'=>strftime($param['long_date_format'], strtotime($user['reg_time'])),
    'reg_country_by_ip'=> $geoip->country_name_by_addr($user['reg_ip']),
    'reg_ip'=> (!empty($user['reg_ip'])) ? $user['reg_ip'] : getTranslateText('UNDEFINED'),
    'login_time'=>strftime($param['long_date_format'], strtotime($user['last_login_time'])),
    'login_country_by_ip'=> $geoip->country_name_by_addr($user['ip']),
    'login_ip'=>(!empty($user['ip'])) ? $user['ip'] : getTranslateText('UNDEFINED'),

    'R_SITEURL'=>$user['website_url'],
    'R_F_NAME'=>$user['first_name'],
    'R_L_NAME'=>$user['last_name'],
    'R_EMAIL'=>"<a href=\"mailto:$user[email]\">$user[email]</a>",
    'R_URL'=>"<a href=\"$user[website_url]\" target=\"_blank\">$user[website_url]</a>",
    'R_PHONE'=>$user['phone'],
    'R_FAX'=>$user['fax'],
    'R_SSN'=>$user['ssn'],
    'R_ADDRESS1'=>$user['addr1'],
    'R_ADDRESS2'=>$user['addr2'],
    'R_CITY'=>$user['city'],
    'R_ZIP'=>$user['zip'],
    'R_STATE'=>$user['state'],
    'COUNTRY_NAME'=> $country,
    'BIRTHDAY'=>strftime($param['short_date_format'], strtotime($user['birthday']))
)as $k => $v) {
    $xtpl->assign($k,$v);
}

/**
 * Information about withdraw
 */
$withdray_rs=$db->query("SELECT t1.*, t2.caption FROM $param[dbprefix]withdraw_users as t1, $param[dbprefix]withdraw_type t2 WHERE t2.active='1' AND t1.withdrawid=t2.id AND t1.affiliateid=?", array($_REQUEST['id']));
$withdray=$withdray_rs->fetchRow(DB_FETCHMODE_ASSOC);
$xtpl->assign('TYPE', $withdray['caption']);
$xtpl->assign('CUR', getCurrencyTextType($withdray['currencyid'], true));

$tmp_tpl_filename = getTemplateFullPath('withdraw_forms.html');
$xtpl->assign_file('withdraw_forms', $tmp_tpl_filename);
$var_list = explode(getParamByName('separator_chars'), $withdray['variables']);

//country for withdraw
if ($withdray['withdrawid']=='1') {
    $country = $db->getOne("SELECT cname FROM $param[dbprefix]countries WHERE lang_id=? AND cnumber=?", array(getLanguageId(), $var_list[4]));
    $xtpl->assign("V14_CAPTION", $country);
}
if ($withdray['withdrawid']=='2') {
    $country = $db->getOne("SELECT cname FROM $param[dbprefix]countries WHERE lang_id=? AND cnumber=?", array(getLanguageId(), $var_list[8]));
    $xtpl->assign("V28_CAPTION", $country);
}

for ($i=0; $i < count ($var_list); $i++) {
     $xtpl->assign('V'.$withdray['withdrawid'].$i, nl2br($var_list[$i]));
}

$xtpl->parse("template.withdraw_forms.viewform".$withdray['withdrawid']);
$xtpl->parse("template.withdraw_forms");

/**
 * Information about balance
 */
$tr_rs = $db->query("SELECT txn_type, sum(amount) as sum_amount, orig_cur_index FROM $param[dbprefix]transactions WHERE user_id=? AND approved=1 GROUP BY orig_cur_index HAVING sum_amount>0", array($_REQUEST['id']));
while($tr_row = $tr_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
    $xtpl->assign('type', getTransactionTextType($tr_row['txn_type']));
    $xtpl->assign('amount', moneytextformat($tr_row['sum_amount'], $tr_row['orig_cur_index']));
    $xtpl->parse('template.transaction_info');
}

/**
 * Information about last paid
 */
$tr_rs = $db->query("SELECT txn_type, abs(amount), orig_cur_index,  DATE_FORMAT(create_date, '%m/%d%/%Y %T') as create_date FROM $param[dbprefix]transactions WHERE txn_type=? AND user_id=? LIMIT 0,10", array($transaction_types['debit_payout'], $_REQUEST['id']));
if (0 != $tr_rs->numRows()) {
    while($tr_row = $tr_rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        $lastpaid =  moneytextformat($tr_row['amount'], $tr_row['orig_cur_index']) . " ($tr_row[create_date])";
        $xtpl->assign('lastpaid',$lastpaid);
        $xtpl->parse('template.lastpaid_info.loop');
    }
    $xtpl->parse('template.lastpaid_info');
}

$xtpl->assign('report_filename', urlencode(base64_encode('acc_det')));
$xtpl->assign('sql_filter', urlencode(base64_encode('')));

unset($geoip);
ending();
?>