<?php
// $Id: admincfg.php 12 2009-08-06 04:53:53Z adgar $

/******************************    
* Initialization
 ******************************/ 
$os = (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') ? 'win' : 'nix';
if ('win' == $os) {
    if (!defined('DIRECTORY_SEPARATOR'))  define('DIRECTORY_SEPARATOR', '\\');
    if (!defined('PATH_SEPARATOR'))  define('PATH_SEPARATOR', ';');
    if (!defined('PHP_SHLIB_SUFFIX'))  define('PHP_SHLIB_SUFFIX', 'dll');
    if (!isset($_SERVER['QUERY_STRING'])) $_SERVER['QUERY_STRING'] = '';    
    if (strstr($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS')) $_SERVER['REQUEST_URI'] = $_SERVER['PATH_INFO'] . '?' . $_SERVER['QUERY_STRING'];    
} else {
    if (!defined('DIRECTORY_SEPARATOR'))  define('DIRECTORY_SEPARATOR', '/');
    if (!defined('PATH_SEPARATOR'))  define('PATH_SEPARATOR', ':');    
    if (!defined('PHP_SHLIB_SUFFIX'))  define('PHP_SHLIB_SUFFIX', 'so');
}

$absbase = realpath(dirname(__FILE__) . '/../');
$include_path = array(
  './',
  $absbase,        
  $absbase . '/config',
  $absbase . '/lib',
  $absbase . '/include'
);

ini_set('include_path', implode(PATH_SEPARATOR, $include_path));
unset($os, $absbase);

/******************************    
* Include core libraries
 ******************************/ 
require_once('common.inc.php');
if (!defined('DEFAULT_JOIN_CURRENCY')) define('DEFAULT_JOIN_CURRENCY', getParamByName('def_join_currency'));

/*************************************
* @Set templates path
*
**************************************/
define('TPL_FOLDER', 'admin');

$base = HTTP_ADDR . 'admin';
$base1 = rtrim(HTTP_ADDR, '\\/');

if (!in_array($param['selfname'], array('index.php', 'activate.php')))
    checkAccess('A');        

/**
 * Tab items
 */
$tab_items = array();
$tab_items[] = array('tab_intex'=> 1, 'translate_key' =>  'TOPTAB_ADM_MENU_ACCOUNTS', 'location' => 'affiliates.php');
$tab_items[] = array('tab_intex'=> 2, 'translate_key' =>  'TOPTAB_ADM_SAL_ACTIVITY', 'location' => 'transactions.php');
$tab_items[] = array('tab_intex'=> 3, 'translate_key' =>  'TOPTAB_ADM_MENU_STATISTICS', 'location' => 'quick_stats.php');
$tab_items[] = array('tab_intex'=> 4, 'translate_key' =>  'TOPTAB_ADM_MENU_PRODUCTS', 'location' => 'groups.php');
$tab_items[] = array('tab_intex'=> 5, 'translate_key' =>  'TOPTAB_ADM_MENU_BANNERS', 'location' => 'banimg_edit.php');
$tab_items[] = array('tab_intex'=> 6, 'translate_key' =>  'TOPTAB_ADM_MENU_EMAILS', 'location' => 'emails_conf.php');
$tab_items[] = array('tab_intex'=> 7, 'translate_key' =>  'TOPTAB_ADM_MENU_SYS_SETUP', 'location' => 'site_conf.php');
$tab_items[] = array('tab_intex'=> 8, 'translate_key' =>  'TOPTAB_ADM_MENU_TRANSLATION', 'location' => 'translation.php');
$tab_items[] = array('tab_intex'=> 9, 'translate_key' =>  'TOPTAB_ADM_MENU_HELP', 'location' => 'documentation.php');
$tab_items[] = array('tab_intex'=> 10, 'translate_key' => 'TOPTAB_ADM_MENU_CUSTOMIZATION', 'location' => 'page_editor.php');

$cur_tab_list = array(
    1 => array('index.php', 'activate.php', 'affiliates.php', 'aff_app.php', 'aff_edit.php', 'aff_pay.php', 'pay.php', 'tiers.php', 'msales.php', 'delete.php', 'details.php'),
    2 => array('transaction_approve.php', 'transaction_info.php', 'transactions.php', 'recurring_sales.php', 'current_sales.php'),
    3 => array('quick_stats.php', 'traffic.php', 'traffic_info.php', 'payout_history.php', 'ppc_stats.php', 'affiliate_stats.php', 'product_stats.php', 'impressions_stats.php', 'country_stats.php'),
    4 => array('gr_add.php', 'gr_edit.php', 'groups.php'),
    5 => array('banimg_add.php', 'banimg_edit.php', 'banswf_add.php', 'banswf_edit.php', 'bantext_add.php', 'bantext_edit.php'),
    6 => array('emails_conf.php', 'emails_send.php', 'emails_settings.php'),
    7 => array('admins.php', 'backups.php', 'cur_conf.php', 'meta_editor.php', 'pay_rates.php', 'site_conf.php', 'encodings.php'),
    8 => array('translation.php'),
    9 => array('documentation.php', 'news.php', 'terms.php', 'tickets.php'), 
    10 => array('page_editor.php', 'faq_editor.php', 'color_editor.php')
);

?>